package org.finconsgroup.itserr.criterion.common.service;


/**
 * Service interface for User management operations.
 *
 * <p>Provides business logic for user registration, authentication, password management,
 * and profile operations. This service handles the core user lifecycle including
 * account creation, login with automatic inactivity checks, password reset flows,
 * and profile updates.</p>
 *
 * <p>Security features:</p>
 * <ul>
 *   <li>Automatic status change to 'Inactive' after 30 days without login</li>
 *   <li>Reset code expiration after 15 minutes</li>
 *   <li>Password strength validation</li>
 *   <li>Email uniqueness enforcement</li>
 * </ul>
 *
 */
public interface CommonEmailService {

    // ========== SEND EMAIL ==========

    /**
     * Sends a plain text email
     *
     * @param receiver recipient email address
     * @param subject  email subject
     * @param body     email body content
     * @return true if email was sent successfully, false otherwise
     */
    boolean sendEmail(String receiver, String subject, String body);

}