package org.finconsgroup.itserr.criterion.common.client;

import org.finconsgroup.itserr.criterion.common.dto.NotificationDto;
import org.finconsgroup.itserr.criterion.common.dto.RequestNotificationDto;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

@Service
public class NotificationClient {

    private final RestTemplate internalRestTemplate;

    public NotificationClient(@Qualifier("internalRestTemplate") RestTemplate internalRestTemplate) {
        this.internalRestTemplate = internalRestTemplate;
    }

    public List<NotificationDto> createNotification(RequestNotificationDto requestNotificationDto) {
        String url = "http://localhost:8082/api/v1/notification/create";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        HttpEntity<RequestNotificationDto> request = new HttpEntity<>(requestNotificationDto, headers);

        NotificationDto[] body = internalRestTemplate.postForObject(url, request, NotificationDto[].class);
        return (body != null) ? Arrays.asList(body) : Collections.emptyList();
    }

    public NotificationDto updateNotification(UUID notificationId) {
        String url = "http://localhost:8082/api/v1/notification/update/{id}";
        return internalRestTemplate.postForObject(url, null, NotificationDto.class, notificationId);
    }

}