package org.finconsgroup.itserr.criterion.common.dto;


import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Set;
import java.util.UUID;

/**
 * Data Transfer Object for NotificationEntity
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class RequestNotificationDto {
    @NotNull
    private UUID notificationOwnerId;
    private UUID documentOwnerId;
    private UUID documentId;
    @NotNull
    private Set<UUID> recipientUserId;
    @NotNull
    private Integer notificationEventId;
    private String customNotificationMessage;
}
