/*
 * Decompiled with CFR 0.152.
 */
package org.finconsgroup.itserr.criterion.common.service.impl;

import lombok.Generated;
import org.finconsgroup.itserr.criterion.common.service.CommonEmailService;
import org.finconsgroup.itserr.criterion.common.util.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Service;

@Service
public class DefaultEmailService
implements CommonEmailService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultEmailService.class);
    private final JavaMailSender mailSender;
    @Value(value="${spring.email.from}")
    private String fromAddress;
    @Value(value="${spring.profiles.active:default}")
    private String activeProfile;

    @Override
    public boolean sendEmail(String receiver, String subject, String body) {
        try {
            if (this.activeProfile.equals(Constants.LOCAL.getValue())) {
                this.printEmailExample(receiver, subject, body);
                return true;
            }
            SimpleMailMessage message = new SimpleMailMessage();
            message.setFrom(this.fromAddress);
            message.setTo(receiver);
            message.setSubject(subject);
            message.setText(body);
            this.mailSender.send(message);
            log.info("Email sent successfully to: {}", (Object)receiver);
            return true;
        }
        catch (Exception e) {
            log.error("Failed to send email to: {}", (Object)receiver, (Object)e);
            return false;
        }
    }

    private void printEmailExample(String receiver, String subject, String body) {
        log.info("\n\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n                    EMAIL NOT SENT (LOCAL PROFILE)                        \n\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\nTo: {}\nSubject: {}\n\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n{}\n\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550", new Object[]{receiver, subject, body});
    }

    @Generated
    public DefaultEmailService(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }
}

